import { View, FlatList } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import { styles } from "./categoriesSkeletonStyle";

const RenderItem = ({ index }) => {
    return (
        <View
            key={`key-${index}`}
            style={styles.container}
        >
            <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle1} />
            <View style={styles.skeletonElementContainer}>
                <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle2} />
                <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle3} />
            </View>
        </View>
    );
};

const CategoriesSkeleton = () => {
    return (
        <FlatList
            data={[1, 2, 3, 4, 5, 6, 7]}
            renderItem={(_, index) => <RenderItem index={index} />}
            keyExtractor={(_, i) => "key" + i}
            style={styles.flatList}
            showsVerticalScrollIndicator={false}
        />
    );
};

export default CategoriesSkeleton;
